// To parse this JSON data, do
//
//     final requestUpdateResponseModel = requestUpdateResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:play_lab/data/model/global/common_api_response_model.dart';

RequestUpdateResponseModel requestUpdateResponseModelFromJson(String str) => RequestUpdateResponseModel.fromJson(json.decode(str));

String requestUpdateResponseModelToJson(RequestUpdateResponseModel data) => json.encode(data.toJson());

class RequestUpdateResponseModel {
  String? remark;
  String? status;
  Message? message;
  Data? data;

  RequestUpdateResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory RequestUpdateResponseModel.fromJson(Map<String, dynamic> json) => RequestUpdateResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  String? voteType;
  String? upvotes;
  String? downvotes;
  String? voteDelete;
  String? subscribed;
  dynamic userVote;

  Data({
    this.voteType,
    this.upvotes,
    this.downvotes,
    this.subscribed,
    this.voteDelete,
    this.userVote,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        voteType: json["vote_type"].toString(),
        upvotes: json["upvotes"].toString(),
        downvotes: json["downvotes"].toString(),
        voteDelete: json["vote_delete"].toString(),
        subscribed: json["subscribed"].toString(),
        userVote: json["user_vote"],
      );

  Map<String, dynamic> toJson() => {
        "vote_type": voteType,
        "upvotes": upvotes,
        "downvotes": downvotes,
        "vote_delete": voteDelete,
        "user_vote": userVote,
      };
}
